#include "typedef.h"
#include "Command.h"
#include "string.h"
#include "Delay.h"
#include "CRC16.h"
#include "usbprint.h"
#include "uart.h"
#include <stdlib.H>
//================================================
#define STATUS_IDLE 0
#define STATUS_BUSY 1
//-------------------------
#define PARA_SET 0
#define PARA_GET 1
//-------------------------
//command id
#define CMD_STATUS			    0x00
#define CMD_CURRENT			    0x01   
#define CMD_LED_SWITCH          0x02//LED   
#define CMD_FLIP			    0x09//ͼת   
#define CTL_IMAGE_DISPXY_00		0x01
#define CTL_IMAGE_DISPXY_10		0x02
#define CTL_IMAGE_DISPXY_01		0x03
#define CTL_IMAGE_DISPXY_11		0x04


#define CMD_POWER_ON_OFF        0x03
#define CTL_POWER_ON            0x01
#define CTL_POWER_OFF           0x02
#define CMD_LED_DEFAULT		    0x04
#define CTL_DEFAULT_ON	        0x00
#define CTL_DEFAULT_OFF	        0x01

#define CMD_LED_EXPOSURE      0x32
#define CMD_FACTORY_FANOFF    0x33

#define CMD_SYSTEM_SATUS        0xf6
#define CMD_PRODUCT_ID_SET      0xf7
#define CMD_PRODUCT_ID_READ     0xf8

#define CMD_VERSION         0x0E
#define CMD_SHAKE_HANDS     0x0F
#define CMD_TEMPERATURE     0x10

#define CMD_UV_PARA         0xcb
#define CMD_UV_AUTO         0xcc
#define CMD_UV_POWER        0xcd
#define CMD_UV              0xce
#define CMD_LED_TEST        0xcf
#define CMD_USE_TIME        0xd0
//****************************************************************
static U8 UartPort = 1;
//unsigned int (*WriteBytes)(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut);
//unsigned int (*ReadBytes)(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut);
__WriteBytes__ WriteBytes=UsbWriteBytes;
__ReadBytes__  ReadBytes=UsbReadBytes;

unsigned char PackageTransmit(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut)
{
	//unsigned char buffer[1028];
	unsigned char *buffer;
	unsigned short crc16;
	unsigned int i,nBytes;

	if(Buffer==NULL)
		return 0;

	buffer=(unsigned char *) malloc (Size+4);

	if(buffer==NULL)
		return 0;

	buffer[0]=(Size+4)&0xff;
	buffer[1]=((Size+4)>>8)&0xff;
	for(i=0;i<Size;i++)
	{
		buffer[2+i]=Buffer[i];
	}
	crc16=CRC16(buffer,Size+2);
	buffer[Size+2]=(crc16>>8)&0xff;
	buffer[Size+3]=crc16&0xff;
	nBytes=WriteBytes(buffer,Size+4,TimeOut);
	if(nBytes==(Size+4))
	{
		free (buffer);
		return 1;
	}
	free (buffer);
	return 0;
}

unsigned char PackageReceive(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut)
{
	//unsigned char buffer[1028];
	unsigned int nBytes=0;
	unsigned int i,Cnt;
	unsigned short crc16;
	unsigned char   *buffer;

	if(Buffer==NULL)
		return 0;
    buffer=(unsigned char *) malloc (Size+4);

	if(buffer==NULL)
		return 0;
    
	nBytes=ReadBytes(buffer,Size+4,TimeOut);
	if(nBytes!=(Size+4))
	{
		free (buffer);
		return 0;
	}
	Cnt=(buffer[1]<<8)|buffer[0];
	if(Cnt !=nBytes)
	{
		free (buffer);
		return 0;
	}

	crc16=CRC16(buffer,Size+2);

    if(CRC16(buffer,Size+4))
	{
		free (buffer);
		return 0;
	}
    for(i=0;i<Size;i++)
		Buffer[i]=buffer[2+i];
	free (buffer);
	return 1;
}

static Bool Command(U8 cmd,U8 *TransmitBuffer,U32 TransmitSize,U8 *ReceiveBuffer,U32 ReceiveSize,U32 TimeOut)
{
	U32 i;
	unsigned char *buffer;

	if(TransmitBuffer==NULL && TransmitSize>0)
		return FALSE;
		
    buffer=(unsigned char *) malloc (TransmitSize+4);

	if(buffer==NULL)
		return FALSE;

    buffer[0]=cmd;

	for(i=0;i<TransmitSize;i++)
	{
		buffer[i+1]=TransmitBuffer[i];
	}

	if(PackageTransmit(buffer,TransmitSize+1,TimeOut)==0)
	{
		return FALSE;
	}

	if(ReceiveSize==0)
		return TRUE;

	if(ReceiveBuffer==NULL)
		return FALSE;

	if(PackageReceive(ReceiveBuffer,ReceiveSize,TimeOut))
	{
		return TRUE;
	}

	return FALSE;
}


unsigned char GetStatus(void)
{
	unsigned char buffer[10];
	unsigned char Value;
	buffer[0]=CMD_STATUS;
	PackageTransmit(buffer,1,1000);
	PackageReceive(&Value,1,1000);
	return Value;
}

//
//U8 index  LEDĬΪ0
//unsigned char flagLEDأ0x00ǿ0x01ǹ
//

Bool LedOnOff(U8 index,unsigned char flag)
{
    U8 buffer[6];
	
	buffer[0]=flag;
	buffer[1]=index;

	if(Command(CMD_LED_SWITCH,buffer,2,NULL,0,500)==FALSE)
		return FALSE;
	return TRUE;
}



Bool GetCurrent(U8 index,U8 *Value)
{
	U8 buffer[50];
	buffer[0]=PARA_GET;
	buffer[1]=index;
	if(Command(CMD_CURRENT,buffer,2,buffer,1,500)==FALSE)
	{
		*Value=0;
		return FALSE;
	}
	*Value=buffer[0];
	return TRUE;
}


Bool SetCurrent(U8 index,U8 Value)
{
	U8 buffer[7];
	buffer[0]=PARA_SET;
	buffer[1]=Value;
	buffer[2]=index;
	
	if(Command(CMD_CURRENT,buffer,3,NULL,0,500)==FALSE)
		return FALSE;
	return TRUE;
}

//==============================================================
Bool Flip(unsigned char FlipX,unsigned char FlipY)
{
	U8 buffer[3],Value=0x01;

	if(FlipX==0 && FlipY==0)
		Value=CTL_IMAGE_DISPXY_00;
	if(FlipX==1 && FlipY==0)
		Value=CTL_IMAGE_DISPXY_10;
	if(FlipX==0 && FlipY==1)
		Value=CTL_IMAGE_DISPXY_01;
	if(FlipX==1 && FlipY==1)
		Value=CTL_IMAGE_DISPXY_11;

	buffer[0]=PARA_SET;
	buffer[1]=Value;
	if(Command(CMD_FLIP,buffer,2,NULL,0,500)==FALSE)
		return FALSE;
	return TRUE;
}

unsigned char  GetProductID(unsigned char *pID)
{
    unsigned char buffer[8];
    if(pID==NULL)
        return FALSE;
    //size =id (6byte) + date (2byte)
    buffer[0]=CMD_PRODUCT_ID_READ;
    PackageTransmit(buffer,2,1000);
    PackageReceive(pID,8,1000);
    //ID0  = buffer[0]; //ID:(6byte)
    //ID1  = buffer[1];
    //ID2  = buffer[2];
    //ID3  = buffer[3];
    //ID4  = buffer[4];
    //ID5  = buffer[5];
    //ID6  = buffer[6]; //yy/ww(2byte)
    //ID7  = buffer[7] %12;
    pID[7] = pID[7] %12;
    return TRUE;
}

unsigned char GetSysStatus(void)
{
    unsigned char buffer[5];
    unsigned char Value;
    buffer[0]=CMD_SYSTEM_SATUS;
    PackageTransmit(buffer,1,1000);
    PackageReceive(&Value,1,1000);
    return Value;
}

unsigned char PowerOnOff(unsigned char flag)
{
    unsigned char buffer[5];
    buffer[0]=CMD_POWER_ON_OFF;
	if(flag)
		buffer[1]=CTL_POWER_ON;
	else
		buffer[1]=CTL_POWER_OFF;
    PackageTransmit(buffer,2,1000);
	return TRUE;
}

Bool GetLedDefaultStatus(U8 *flag)
{
	U8 buffer[50];
	buffer[0]=PARA_GET;
	if(Command(CMD_LED_DEFAULT,buffer,1,buffer,1,500)==FALSE)
	{
		*flag=0;
		return FALSE;
	}
	*flag=buffer[0];
	return TRUE;
}


Bool SetLedDefaultStatus(U8 flag)
{
	U8 buffer[7];
	buffer[0]=PARA_SET;

	if(flag)
		buffer[1]=CTL_DEFAULT_OFF;
	else
		buffer[1]=CTL_DEFAULT_ON;
	
	if(Command(CMD_LED_DEFAULT,buffer,2,NULL,0,500)==FALSE)
		return FALSE;
	return TRUE;
}

Bool GetTemperature(S16 *Temperature)
{
	U8 buffer[10];
	if(Command(CMD_TEMPERATURE,NULL,0,buffer,2,500)==FALSE)
	{
		*Temperature=-100;
		return FALSE;
	}
	*Temperature=buffer[0]|(buffer[1]<<8);
	return TRUE;
}

Bool GetUseTime(U32 *UseTime)
{
	U8 buffer[10];
	U32 *p=(U32*)buffer;
	if(Command(CMD_USE_TIME,NULL,0,buffer,4,500)==FALSE)
	{
		*UseTime=0;
		return FALSE;
	}
	//*UseTime=buffer[0]|(buffer[1]<<8)|(buffer[2]<<16)|(buffer[3]<<24);
	*UseTime=*p;
	return TRUE;
}

Bool LedTest(U8 *Result)
{
	U8 buffer[10];
	if(Command(CMD_LED_TEST,NULL,0,buffer,1,500)==FALSE)
	{
		//*Result=0;
		return FALSE;
	}
	*Result=buffer[0];
	return TRUE;
}

Bool GetUvValue(U16 *Value)
{
	U8 buffer[10];
	U16 *p=(U16*)buffer;
	if(Command(CMD_UV,NULL,0,buffer,2,500)==FALSE)
	{
		*Value=0;
		return FALSE;
	}
	*Value=*p;
	return TRUE;
}

Bool SetUvPower(U16 Value)//λmW
{
	U8 buffer[10];
	buffer[0]=PARA_SET;
	buffer[1]=Value&0xff;
	buffer[2]=(Value>>8)&0xff;
	if(Command(CMD_UV_POWER,buffer,3,buffer,3,500)==FALSE)
	{
		//*Result=0;
		return FALSE;
	}
	if(buffer[0]=='A' && buffer[1]=='c' && buffer[2]=='k')
		return TRUE;
	return FALSE;
}

Bool GetUvPower(U16 *Value)//λmW
{
	U8 buffer[10];
	buffer[0]=PARA_GET;
	if(Command(CMD_UV_POWER,buffer,1,buffer,2,500)==FALSE)
	{
		//*Result=0;
		return FALSE;
	}
    *Value=(buffer[1]<<8)|buffer[0];
	return TRUE;
}

Bool SetUvAuto(U8 flag)
{
	U8 buffer[10];
	buffer[0]=PARA_SET;
	buffer[1]=flag;
	if(Command(CMD_UV_AUTO,buffer,2,buffer,3,500)==FALSE)
	{
		//*Result=0;
		return FALSE;
	}
	if(buffer[0]=='A' && buffer[1]=='c' && buffer[2]=='k')
		return TRUE;
	return FALSE;
}

Bool GetUvAuto(U8 *flag)
{
	U8 buffer[10];
	buffer[0]=PARA_GET;
	if(Command(CMD_UV_AUTO,buffer,1,buffer,1,500)==FALSE)
	{
		//*Result=0;
		return FALSE;
	}
    *flag=buffer[0];
	return TRUE;
}

Bool SetUvPara(float k,float b)
{
	float fK,fB;
	S32 *K,*B;
	U8 buffer[10];
	buffer[0]=PARA_SET;
	K=(S32*)&buffer[1];
	B=(S32*)&buffer[5];
	fK=k*10000;
	fB=b*10000;
	*K=(S32)fK;
	*B=(S32)fB;
	if(Command(CMD_UV_PARA,buffer,9,buffer,3,500)==FALSE)
	{
		//*Result=0;
		return FALSE;
	}
	if(buffer[0]=='A' && buffer[1]=='c' && buffer[2]=='k')
		return TRUE;
	return FALSE;
}

Bool GetUvPara(float *k,float *b)
{
	S32 *pK;
	S32 *pB;
	U8 buffer[10];
	buffer[0]=PARA_GET;
	if(Command(CMD_UV_PARA,buffer,1,buffer,8,500)==FALSE)
	{
		//*Result=0;
		return FALSE;
	}
	pK=(S32*)buffer;
	pB=(S32*)&buffer[4];
    *k=(*pK)/10000.0f;
	*b=(*pB)/10000.0f;
	return TRUE;
}


Bool SetMyVersion(U16 Value)
{
	U16 version;
	U8 buffer[10];
	buffer[0]=PARA_SET;
	buffer[1]=Value&0xff;
	buffer[2]=(Value>>8)&0xff;
	if(Command(CMD_VERSION,buffer,3,buffer,2,500)==FALSE)
	{
		//*Result=0;
		return FALSE;
	}
	version=buffer[0]|(buffer[1]<<8);
	if(version==Value)
		return TRUE;
	return FALSE;
}

Bool GetMyVersion(U16 *Value)
{
	U8 buffer[10];
	buffer[0]=PARA_GET;
	if(Command(CMD_VERSION,buffer,1,buffer,2,500)==FALSE)
	{
		//*Result=0;
		return FALSE;
	}
    *Value=(buffer[1]<<8)|buffer[0];
	return TRUE;
}


//--------------------------------------------------------------------------

unsigned int UartWriteBytes(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut)
{
   return SendChars(UartPort,Buffer,Size,TimeOut);
}
 
unsigned int UartReadBytes(unsigned char *Buffer,unsigned int Size,unsigned int TimeOut)
{
   return GetChars(UartPort,Buffer,Size,TimeOut);
}
Bool ShakeHands(U8 dwPort,U32 dwBaudRate)
{
  //U8 buffer[7];
  if(dwPort==0)
  {
	  if(EnumUsbDevice()==FALSE)
		  return FALSE;
	  WriteBytes=UsbWriteBytes;
	  ReadBytes=UsbReadBytes;
	  return TRUE;
  }
  /*
  if (OpenUart(dwPort, dwBaudRate, NOPARITY, 8, ONESTOPBIT)== FALSE)//115200
		return FALSE;
  WriteBytes=UartWriteBytes;
  ReadBytes=UartReadBytes;
  UartPort=dwPort;
  if(Command(CMD_SHAKE_HANDS,NULL,0,buffer,3,500)==FALSE)
  {
	  CloseUart(UartPort);
	  return FALSE;
  }
  if(buffer[0]!='A' || buffer[1]!='c' || buffer[2]!='k')
  {
	  CloseUart(UartPort);
	  return FALSE;
  }
  */
	return TRUE;
}

Bool FanOnOff(unsigned char flag)
{
    U8 buffer[6];
	buffer[0]=flag;	
	if(Command(CMD_FACTORY_FANOFF,buffer,2,NULL,0,500)==FALSE)
		return FALSE;
	return TRUE;
}






